# Open Journal Systems

[![Build Status](https://app.travis-ci.com/pkp/ojs.svg?branch=main)](https://app.travis-ci.com/pkp/ojs)
[![Scrutinizer Code Quality](https://scrutinizer-ci.com/g/pkp/ojs/badges/quality-score.png?b=main)](https://scrutinizer-ci.com/g/pkp/ojs/?branch=main)

Open Journal Systems (OJS) is open source software developed by the [Public Knowledge Project](https://pkp.sfu.ca/) to manage scholarly journals. [Learn More](https://pkp.sfu.ca/software/ojs/)

## Usage

Read one of these guides to get started using OJS:

- Read the [Admin Guide](https://docs.pkp.sfu.ca/admin-guide/) to learn how to install and configure the application from an official release package. Use this guide to deploy to production.
- Read the [Getting Started](https://docs.pkp.sfu.ca/dev/documentation/en/getting-started) guide to learn how to install the application from this source repository. Use this guide for local development.

Visit our [Documentation Hub](https://docs.pkp.sfu.ca/) for user guides, tutorials, and technical documentation.

## Bugs / Feature Requests

> ⚠️ If you have found a security risk or vulnerability, please read our [security policy](SECURITY.md).

All issues should be filed at the [pkp/pkp-lib](https://github.com/pkp/pkp-lib/issues/) repository. Feature requests can be made at our [Community Forum](https://forum.pkp.sfu.ca/). Learn more about how to [report a problem](https://docs.pkp.sfu.ca/dev/contributors/#report-a-problem).

## Community Code of Conduct

This repository is a PKP community space. All activities here are governed by [PKP's Code of Conduct](https://pkp.sfu.ca/code-of-conduct/). Please review the Code and help us create a welcoming environment for all participants.

## Contributions

Read the [Contributor's Guide](https://docs.pkp.sfu.ca/dev/contributors/) to learn how to make a pull request. This document describes our code formatting guidelines as well as information about how we organize stable branches and submodules.

## License

This software is released under the the GNU General Public License. See the file `docs/COPYING` included with this distribution for the terms of this license.

Third parties are welcome to modify and redistribute OJS in entirety or parts according to the terms of this license. PKP also welcomes patches for improvements or bug fixes to the software.
